function [fitresult, gof] = createFit(X_ring, Y_ring, Z_ring,plot_cond)
%CREATEFIT(X_RING,Y_RING,Z_RING)
%  Create a fit.
%
%  Data for 'Ring Plane' fit:
%      X Input: X_ring
%      Y Input: Y_ring
%      Z Output: Z_ring
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 27-Sep-2024 11:45:01

if nargin < 4
    plot_cond = false;
end

%% Fit: 'Ring Plane'.
[xData, yData, zData] = prepareSurfaceData( X_ring, Y_ring, Z_ring );

% Set up fittype and options.
ft = fittype( 'poly11' );

% Fit model to data.
[fitresult, gof] = fit( [xData, yData], zData, ft );

% Plot fit with data.
if plot_cond
figure( 'Name', 'Ring Plane' );
h = plot( fitresult, [xData, yData], zData );
legend( h, 'Ring Plane', 'Z_ring vs. X_ring, Y_ring', 'Location', 'NorthEast', 'Interpreter', 'none' );
% Label axes
xlabel( 'X_ring', 'Interpreter', 'none' );
ylabel( 'Y_ring', 'Interpreter', 'none' );
zlabel( 'Z_ring', 'Interpreter', 'none' );
grid on
end


